import * as React from 'react';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarHardware, CarHardwareProps } from 'features/CarHardware/ui/CarHardware/CarHardware';

import { useCar } from 'entities/Car/api/useCar/useCar';
import { useCarTelematics } from 'entities/Car/api/useCarTelematics/useCarTelematics';

const storybookMeta = createStorybookMeta<CarHardwareProps>({
    title: 'features/CarHardware/CarHardware',
    component: CarHardware,

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarHardwareProps & { id: string }>(({ id, ...otherProps }) => {
    const carResource = useCar({
        carId: id,
        sensors: ['speed', 'mileage', 'fuel_level', 'fuel_distance', 'ext_voltage', 'engine_on', 'gsm_signal_level'],
    });
    const carTelematicsResource = useCarTelematics({ id });

    return (
        <CarHardware
            {...otherProps}
            resource={carResource}
            carTelematicsResource={carTelematicsResource}
        />
    );
});

export const normal = Template.bind({});
normal.args = {
    id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};

export const editButton = Template.bind({});
editButton.args = {
    id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};
editButton.parameters = {
    flags: {
        car_overview_edit: true,
    },
};

export const addButton = Template.bind({});
addButton.args = {
    id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};
addButton.parameters = {
    flags: {
        car_add: true,
    },
};

export const config = Template.bind({});
config.args = {
    id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};
config.parameters = {
    flags: {
        telematics_config: true,
    },
};
config.hermioneFn = async function hoverState(browser, selector) {
    const menuEl = '[role="menu"]';
    await browser.$('[data-id="config"]').click();

    return browser.assertView('menu', [selector, menuEl]);
};
