import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'License plate': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'License plate',
        ru: 'Номер машины',
        cs: 'Registrační značka',
    },
    Name: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Name',
        ru: 'Имя',
        cs: 'Jméno',
    },
    VIN: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'VIN',
        ru: 'VIN',
        cs: 'VIN',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
