import * as React from 'react';
import cn from 'classnames';

import { EMPTY_DATA } from 'constants/constants';

import { CarServerSchema } from 'entities/Car/api/useCar/useCar';

import { DetailsContainer, DetailsContainerItemOptions } from 'shared/ui/DetailsContainer/DetailsContainer';

import { i18n } from 'features/CarHardware/ui/CarMachineHardware/CarMachineHardware.i18n';

import styles from 'features/CarHardware/ui/CarMachineHardware/CarMachineHardware.css';

export interface CarMachineHardwareProps {
    car: CarServerSchema;
    className?: string;
}

export const CarMachineHardware: React.FC<CarMachineHardwareProps> = function CarMachineHardware({ className, car }) {
    let { model, vin, number } = car ?? {};

    const detailsItems: DetailsContainerItemOptions[] = React.useMemo(() => {
        return [
            {
                label: i18n('Name'),
                id: 'model',
                value: model ?? EMPTY_DATA,
            },

            {
                label: i18n('VIN'),
                id: 'vin',
                value: vin ?? EMPTY_DATA,
            },

            {
                label: i18n('License plate'),
                id: 'number',
                value: number ?? EMPTY_DATA,
            },
        ];
    }, [model, vin, number]);

    return (
        <div className={cn(styles.container, className)}>
            <DetailsContainer items={detailsItems} />
        </div>
    );
};
