import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarTelematicsHardware,
    CarTelematicsHardwareProps,
} from 'features/CarHardware/ui/CarTelematicsHardware/CarTelematicsHardware';

import { CarStatusType } from 'entities/Car/consts/CarStatusType';

const storybookMeta = createStorybookMeta<CarTelematicsHardwareProps>({
    title: 'features/CarHardware/CarTelematicsHardware',
    component: CarTelematicsHardware,

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarTelematicsHardwareProps>(CarTelematicsHardware);

export const noSignal = Template.bind({});
noSignal.args = {
    car: {
        status: CarStatusType.NO_SIGNAL,
    },
    telematics: {
        gsm_signal_level: {
            updated: 5000,
        },
        engine_temperature: {
            updated: 5000,
        },
        can_cls_state: {
            value: 1,
        },
    },
};

export const password = Template.bind({});
password.parameters = {
    flags: { car_telematics_password: true },
};
password.args = {
    car: {
        id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
        status: CarStatusType.RIDING,
    },
    telematics: {},
};
password.hermioneFn = async function hoverState(browser, selector) {
    await browser.$('[data-testid="show-password"]').click();
    await browser.assertView('show', selector);
    await browser.$('[data-testid="hide-password"]').click();

    return browser.assertView('hide', selector);
};

export const riding = Template.bind({});
riding.args = {
    car: {
        status: CarStatusType.RIDING,
        speed: 500,
        aggressive_score: 9.0,
        aggressive_rank: 9.0,
        telematics: {
            fuel_level: 5,
            fuel_distance: 10,
        },
    },
    telematics: {
        gps_used: {
            value: 14,
        },
        VEGA_GPS_INVIEW: {
            value: 20,
        },
        gsm_signal_level: {
            value: 100,
            updated: 5000,
        },
        engine_temperature: {
            value: 9000,
            updated: 5000,
        },
        speed: {
            value: 500,
        },
        engine_on: {
            value: 1,
        },
        ext_voltage: {
            value: 42,
        },
        can_cls_state: {
            value: 0,
        },
    },
};
