import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostCarHardwareInstallData {
    carId: string;
    type: 'car_signal_device' | 'car_hardware_vega' | 'car_hardware_beacon';
    deviceCode: string;
}

interface PostCarHardwareInstallPayload {
    device_code: string;
}

export function postCarHardwareInstall({ carId, deviceCode }: PostCarHardwareInstallData) {
    return fetchRequest<PostCarHardwareInstallPayload, unknown>(
        '/api/leasing/attachments/assign',
        { device_code: deviceCode },
        {
            method: 'POST',
            query: {
                car_id: carId,
            },
        },
    );
}
