import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '0-9 digits on the back of the beacon': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '0-9 digits on the back of the beacon',
        ru: 'Цифры от 0-9 на обратной стороне маяка',
        cs: 'Číslice 0–9 na zadní straně majáku',
    },
    '15-digit number on the back of the beacon': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '15-digit number on the back of the beacon',
        ru: '15-значное число на обратной стороне маяка',
        cs: '15místné číslo na zadní straně majáku',
    },
    IMEI: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'IMEI',
        ru: 'IMEI',
        cs: 'IMEI',
    },
    'Serial number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Serial number',
        ru: 'Серийный номер',
        cs: 'Sériové číslo',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
