import * as React from 'react';

import { CarHardwareBeaconFormSchema } from 'features/CarHardwareInstall/types/CarHardwareBeaconFormSchema';

import { InputSize } from 'shared/consts/InputSize';
import { validateRequired } from 'shared/helpers/validateRequired/validateRequired';
import { useForm, UseFormValidation } from 'shared/hooks/useForm/useForm';
import { UseFormControllerSub } from 'shared/hooks/useFormController/useFormController';
import { ErrorLabel } from 'shared/ui/ErrorLabel/ErrorLabel';
import { ErrorMessage } from 'shared/ui/ErrorMessage/ErrorMessage';
import { FormContainer } from 'shared/ui/FormContainer/FormContainer';
import { FormErrorContainer } from 'shared/ui/FormErrorContainer/FormErrorContainer';
import { FormLabel } from 'shared/ui/FormLabel/FormLabel';
import { Input } from 'shared/ui/Input/Input';

import { i18n } from 'features/CarHardwareInstall/ui/CarHardwareBeaconForm/CarHardwareBeaconForm.i18n';

export interface CarHardwareBeaconFormProps {
    className?: string;

    controller?: UseFormControllerSub<OptionalRecord<CarHardwareBeaconFormSchema>>;
}

const VALIDATION_RULES: UseFormValidation<OptionalRecord<CarHardwareBeaconFormSchema>> = {
    serialNumber: validateRequired(),
    imei: validateRequired(),
};

const INIT_FORM: OptionalRecord<CarHardwareBeaconFormSchema> = {
    serialNumber: '',
    imei: '',
};

export const CarHardwareBeaconForm: React.FC<CarHardwareBeaconFormProps> = function CarHardwareBeaconForm({
    className,
    controller,
}) {
    const { update, errors } = useForm<OptionalRecord<CarHardwareBeaconFormSchema>>({
        init: { ...INIT_FORM },
        validation: VALIDATION_RULES,
        controller,
    });

    return (
        <FormContainer className={className}>
            <FormLabel title={i18n('Serial number')}>
                <FormErrorContainer error={<ErrorLabel errors={errors.serialNumber} />}>
                    <Input
                        inputSize={InputSize.M}
                        placeholder={i18n('0-9 digits on the back of the beacon')}
                        hasClear
                        onInputChange={update('serialNumber')}
                        hasError={Boolean(errors.serialNumber)}
                    />
                </FormErrorContainer>
            </FormLabel>

            <FormLabel title={i18n('IMEI')}>
                <FormErrorContainer error={<ErrorLabel errors={errors.imei} />}>
                    <Input
                        inputSize={InputSize.M}
                        placeholder={i18n('15-digit number on the back of the beacon')}
                        hasClear
                        onInputChange={update('imei')}
                        hasError={Boolean(errors.imei)}
                    />
                </FormErrorContainer>
            </FormLabel>

            <ErrorMessage error={errors._serverError} />
        </FormContainer>
    );
};
