import * as React from 'react';

import { postCarBeaconInstall } from 'features/CarHardwareInstall/api/postCarBeaconInstall/postCarBeaconInstall';
import { CarHardwareBeaconFormSchema } from 'features/CarHardwareInstall/types/CarHardwareBeaconFormSchema';
import { CarHardwareBeaconForm } from 'features/CarHardwareInstall/ui/CarHardwareBeaconForm/CarHardwareBeaconForm';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { useFormController } from 'shared/hooks/useFormController/useFormController';
import { Button } from 'shared/ui/Button/Button';
import { ModalContainer } from 'shared/ui/ModalContainer/ModalContainer';

import { i18n } from 'features/CarHardwareInstall/ui/CarHardwareBeaconModal/CarHardwareBeaconModal.i18n';

export interface CarHardwareBeaconModalProps {
    carId: string;
    className?: string;
    onClose?(): void;
    onChange?(): void;
}

export const CarHardwareBeaconModal: React.FC<CarHardwareBeaconModalProps> = function CarHardwareBeaconModal({
    carId,
    className,
    onClose,
    onChange,
}) {
    const { getValues, validate, setError, controller } =
        useFormController<OptionalRecord<CarHardwareBeaconFormSchema>>();

    const onSubmit = React.useCallback(async () => {
        if (validate()) {
            const data = getValues();

            try {
                await postCarBeaconInstall(carId, data as CarHardwareBeaconFormSchema);
            } catch (error) {
                return setError('_serverError', getFetchErrorMessage(error));
            }

            if (onChange) {
                onChange();
            }

            if (onClose) {
                onClose();
            }
        }
    }, [onClose, onChange, getValues, validate, setError]);

    return (
        <ModalContainer
            className={className}
            title={i18n('Install Beacon')}
            hasClose
            onClose={onClose}
            controls={
                <Button
                    size={ButtonSize.M}
                    color={ButtonColor.PRIMARY}
                    label={i18n('Install Beacon')}
                    onClick={onSubmit}
                />
            }
        >
            <CarHardwareBeaconForm controller={controller} />
        </ModalContainer>
    );
};
