import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '0-9 digits and A-F letters on the back of the camera without O letter': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '0-9 digits and A-F letters on the back of the camera without O letter',
        ru: 'Цифры от 0-9 и буквы A-F на обратной стороне камеры без O',
        cs: 'Číslice 0–9 a písmena A–F na zadní straně kamery bez písmene O.',
    },
    '15-digit number on the back of the camera': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '15-digit number on the back of the camera',
        ru: '15-значное число на обратной стороне камеры',
        cs: '15místné číslo na zadní straně kamery',
    },
    IMEI: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'IMEI',
        ru: 'IMEI',
        cs: 'IMEI',
    },
    'Serial number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Serial number',
        ru: 'Серийный номер',
        cs: 'Sériové číslo',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
