import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Install Camera': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Install Camera',
        ru: 'Установить камеру',
        cs: 'Nainstalovat kameru',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
