import * as React from 'react';

import { postCarCameraInstall } from 'features/CarHardwareInstall/api/postCarCameraInstall/postCarCameraInstall';
import { CarHardwareCameraFormSchema } from 'features/CarHardwareInstall/types/CarHardwareCameraFormSchema';
import { CarHardwareCameraForm } from 'features/CarHardwareInstall/ui/CarHardwareCameraForm/CarHardwareCameraForm';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { useFormController } from 'shared/hooks/useFormController/useFormController';
import { Button } from 'shared/ui/Button/Button';
import { ModalContainer } from 'shared/ui/ModalContainer/ModalContainer';

import { i18n } from 'features/CarHardwareInstall/ui/CarHardwareCameraModal/CarHardwareCameraModal.i18n';

export interface CarHardwareCameraModalProps {
    carId: string;
    className?: string;
    onClose?(): void;
    onChange?(): void;
}

export const CarHardwareCameraModal: React.FC<CarHardwareCameraModalProps> = function CarHardwareCameraModal({
    carId,
    className,
    onClose,
    onChange,
}) {
    const { getValues, validate, setError, controller } =
        useFormController<OptionalRecord<CarHardwareCameraFormSchema>>();

    const onSubmit = React.useCallback(async () => {
        if (validate()) {
            const data = getValues();

            try {
                await postCarCameraInstall(carId, data as CarHardwareCameraFormSchema);
            } catch (error) {
                return setError('_serverError', getFetchErrorMessage(error));
            }

            if (onChange) {
                onChange();
            }

            if (onClose) {
                onClose();
            }
        }
    }, [onClose, onChange, getValues, validate, setError]);

    return (
        <ModalContainer
            className={className}
            title={i18n('Install Camera')}
            hasClose
            onClose={onClose}
            controls={
                <Button
                    size={ButtonSize.M}
                    color={ButtonColor.PRIMARY}
                    label={i18n('Install Camera')}
                    onClick={onSubmit}
                />
            }
        >
            <CarHardwareCameraForm controller={controller} />
        </ModalContainer>
    );
};
