import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Beacon: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Beacon',
        ru: 'Маяк',
        cs: 'Maják',
    },
    Camera: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera',
        ru: 'Камера',
        cs: 'Kamera',
    },
    'Install another device': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Install another device',
        ru: 'Установить еще оборудование',
        cs: 'Nainstalovat jiné zařízení',
    },
    'Install device': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Install device',
        ru: 'Установить оборудование',
        cs: 'Nainstalovat zařízení',
    },
    Telematics: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics',
        ru: 'Телематика',
        cs: 'Telematika',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
