import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarHardwareInstallButton,
    CarHardwareInstallButtonProps,
} from 'features/CarHardwareInstall/ui/CarHardwareInstallButton/CarHardwareInstallButton';

const storybookMeta = createStorybookMeta<CarHardwareInstallButtonProps>({
    title: 'features/CarHardwareInstall/CarHardwareInstallButton',
    component: CarHardwareInstallButton,
});

export default storybookMeta;

const Template = createStorybookTemplate<CarHardwareInstallButtonProps>(CarHardwareInstallButton);

export const normal = Template.bind({});
normal.args = {};

normal.hermioneFn = async (browser, selector) => {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();

    await browser.assertView('opened', [selector, menuEl]);
};
