import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '15-digit number on the back of the telematics block': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '15-digit number on the back of the telematics block',
        ru: '15-значное число на обратной стороне блока телематики',
        cs: '15místné číslo na zadní straně bloku telematiky',
    },
    IMEI: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'IMEI',
        ru: 'IMEI',
        cs: 'IMEI',
    },
    Type: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Type',
        ru: 'Тип',
        cs: 'Typ',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
