import * as React from 'react';

import { postCarTelematicsInstall } from 'features/CarHardwareInstall/api/postCarTelematicsInstall/postCarTelematicsInstall';
import { CarHardwareTelematicsFormSchema } from 'features/CarHardwareInstall/types/CarHardwareTelematicsFormSchema';
import { CarHardwareTelematicsForm } from 'features/CarHardwareInstall/ui/CarHardwareTelematicsForm/CarHardwareTelematicsForm';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { useFormController } from 'shared/hooks/useFormController/useFormController';
import { Button } from 'shared/ui/Button/Button';
import { ModalContainer } from 'shared/ui/ModalContainer/ModalContainer';

import { i18n } from 'features/CarHardwareInstall/ui/CarHardwareTelematicsModal/CarHardwareTelematicsModal.i18n';

export interface CarHardwareTelematicsModalProps {
    carId: string;
    className?: string;
    onClose?(): void;
    onChange?(): void;
}

export const CarHardwareTelematicsModal: React.FC<CarHardwareTelematicsModalProps> =
    function CarHardwareTelematicsModal({ carId, className, onClose, onChange }) {
        const { getValues, validate, setError, controller } =
            useFormController<OptionalRecord<CarHardwareTelematicsFormSchema>>();

        const onSubmit = React.useCallback(async () => {
            if (validate()) {
                const data = getValues();

                try {
                    await postCarTelematicsInstall(carId, data as CarHardwareTelematicsFormSchema);
                } catch (error) {
                    return setError('_serverError', getFetchErrorMessage(error));
                }

                if (onChange) {
                    onChange();
                }

                if (onClose) {
                    onClose();
                }
            }
        }, [onClose, onChange, getValues, validate, setError]);

        return (
            <ModalContainer
                className={className}
                title={i18n('Install Telematics')}
                hasClose
                onClose={onClose}
                controls={
                    <Button
                        size={ButtonSize.M}
                        color={ButtonColor.PRIMARY}
                        label={i18n('Install Telematics')}
                        onClick={onSubmit}
                    />
                }
            >
                <CarHardwareTelematicsForm controller={controller} />
            </ModalContainer>
        );
    };
