import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and time',
        ru: 'Дата и время',
        cs: 'Datum a čas',
    },
    Duration: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Duration',
        ru: 'Длительность',
        cs: 'Doba trvání',
    },
    'Latest rides': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Latest rides',
        ru: 'Последние поездки',
        cs: 'Poslední jízdy',
    },
    Mileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage',
        ru: 'Пробег',
        cs: 'Počet ujetých kilometrů',
    },
    'There is no data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'There is no data',
        ru: 'Нет данных',
        cs: 'Nejsou k dispozici žádná data',
    },
    'View all rides': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'View all rides',
        ru: 'Показать все поездки',
        cs: 'Zobrazit všechny jízdy',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
