import * as React from 'react';
import { useHistory, useLocation } from 'react-router-dom';

import { MODAL_OBJECT_ID_CGI, MODAL_OBJECT_TYPE_CGI } from 'constants/constants';

import getDuration from 'utils/sessions/getDuration';
import getFinish from 'utils/sessions/getFinish';
import getSessionId from 'utils/sessions/getSessionId';
import getStart from 'utils/sessions/getStart';

import { RideSchema } from 'entities/Ride/types/RideSchema';

import { Table } from 'shared/ui/Table/Table';

import { getSessionDurationString } from 'components/Cars/CarCard/CarSessionsTable/getSessionDurationString';
import { getSessionMileageString } from 'components/Cars/CarCard/CarSessionsTable/getSessionMileageString';
import { SessionTime } from 'components/Cars/CarCard/CarSessionsTable/sessionTime';
import { ModalObjectTypes } from 'components/types';

export interface CarLatestRideRowProps {
    className?: string;

    ride: RideSchema;
}

export const CarLatestRideRow: React.FC<CarLatestRideRowProps> = function CarLatestRideRow({ className, ride }) {
    const location = useLocation();
    const history = useHistory();

    // @TODO DRIVEMATICSDEV-366
    const startTime = getStart(ride)?.timestamp;
    const sessionId = getSessionId(ride);

    const onRowClick = React.useCallback(() => {
        let searchParams = new URLSearchParams(location.search);
        searchParams.set(MODAL_OBJECT_TYPE_CGI, ModalObjectTypes.SESSION);
        searchParams.set(MODAL_OBJECT_ID_CGI, sessionId ?? '');
        history.push(`${location.pathname}?${searchParams}`);
    }, [history, location.pathname, location.search, sessionId]);

    return (
        <Table.Row
            className={className}
            key={startTime}
            onClick={onRowClick}
        >
            <Table.Td gap />
            <Table.Td>
                <SessionTime
                    start={startTime}
                    finish={getFinish(ride)?.timestamp}
                />
            </Table.Td>
            <Table.Td>{getSessionDurationString(getDuration(ride))}</Table.Td>
            <Table.Td>{getSessionMileageString(ride)}</Table.Td>
            <Table.Td gap />
        </Table.Row>
    );
};
