import * as React from 'react';
import { MemoryRouter, Route } from 'react-router-dom';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarLocation, CarLocationProps } from 'features/CarLocation/ui/CarLocation/CarLocation';

import { useCar } from 'entities/Car/api/useCar/useCar';

import { Path } from 'shared/consts/Path';

const storybookMeta = createStorybookMeta<CarLocationProps>({
    title: 'features/CarLocation/CarLocation',
    component: CarLocation,

    args: {
        storybookWidth: '500px',
    },

    hermioneOptions: { ignoreElements: ['[data-testid="map"]', '[data-testid="address"]'] },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarLocationProps & { carId: string }>(({ carId, ...props }) => {
    const carResource = useCar({
        carId,
        sensors: ['speed', 'mileage', 'fuel_level', 'fuel_distance', 'ext_voltage', 'engine_on', 'gsm_signal_level'],
    });

    return (
        <MemoryRouter initialEntries={['/cars/000c7f42-fa23-8c5c-216f-d1faeb1743c5/overview']}>
            <Route path={Path.CAR_OVERVIEW}>
                <CarLocation
                    {...props}
                    resource={carResource}
                />
            </Route>
        </MemoryRouter>
    );
});

export const normal = Template.bind({});
normal.args = {
    carId: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};

export const camera = Template.bind({});
camera.args = {
    carId: '07c9d2e4-e01d-f120-2781-62bca1d8a7f5',
};

export const withButtons = Template.bind({});
withButtons.args = {
    carId: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};
withButtons.parameters = {
    flags: {
        manage_car_doors: true,
        flag_car_panic_buttons: true,
        show_car_service: true,
    },
};
