import * as React from 'react';
import { useMemo } from 'react';

import { CarLocationTags } from 'entities/Car/consts/CarLocationTags';

import { i18n } from 'features/CarLocation/ui/CarLocationAreaStatus/CarLocationAreaStatus.i18n';

import CheckIcon from 'shared/ui/Icons/images/check-filled-16.inline.svg';

import styles from 'features/CarLocation/ui/CarLocationAreaStatus/CarLocationAreaStatus.css';

export interface CarLocationAreaStatusProps {
    className?: string;
    status: CarLocationTags;
}

export const CarLocationAreaStatus: React.FC<CarLocationAreaStatusProps> = function CarLocationAreaStatus({ status }) {
    const areaStatus = useMemo(() => {
        return {
            [CarLocationTags.UNKNOWN]: i18n('Unknown area'), // Сurrent position is unknown
            [CarLocationTags.AVAILABLE]: (
                <>
                    <CheckIcon className={styles.check} />
                    {i18n('Available area')}
                </>
            ),
            // In available area
            [CarLocationTags.RESTRICTED]: i18n('Restricted area'),
        }[status];
    }, [status]);

    return <div className={styles.status}>{areaStatus}</div>;
};
