import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Block car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Block car',
        ru: 'Заблокировать',
        cs: 'Blokovat vůz',
    },
    Horn: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Horn',
        ru: 'Гудок',
        cs: 'Klakson',
    },
    Lock: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Lock',
        ru: 'Закрыть',
        cs: 'Zamknout',
    },
    'Move to service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Move to service',
        ru: 'В сервис',
        cs: 'Přesunout do servisu',
    },
    'Move to service?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Move to service?',
        ru: 'Перевести в сервисный режим?',
        cs: 'Přesunout do servisu?',
    },
    'Return from service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Return from service',
        ru: 'Из сервиса',
        cs: 'Vrátit ze servisu',
    },
    'Return from service?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Return from service?',
        ru: 'Снять сервисный режим?',
        cs: 'Vrátit ze servisu?',
    },
    'Unblock car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unblock car',
        ru: 'Разблокировать',
        cs: 'Odblokovat vůz',
    },
    Unlock: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unlock',
        ru: 'Открыть',
        cs: 'Odemknout',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
