import React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarLocationButtons,
    CarLocationButtonsProps,
} from 'features/CarLocation/ui/CarLocationButtons/CarLocationButtons';

import { useCar } from 'entities/Car/api/useCar/useCar';

const storybookMeta = createStorybookMeta<CarLocationButtonsProps>({
    title: 'features/CarLocation/ui/CarLocationButtons/CarLocationButtons',
    component: CarLocationButtons,

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarLocationButtonsProps>((props) => {
    const carResource = useCar({
        carId: '5f9fa734-884c-9330-fe49-3d0e311cc4ab',
    });

    return (
        <CarLocationButtons
            {...props}
            resource={carResource}
        />
    );
});

export const manageDoorsAdmin = Template.bind({});
manageDoorsAdmin.args = {};
manageDoorsAdmin.parameters = {
    flags: {
        is_admin: true,
    },
};

export const manageDoorsWithService = Template.bind({});
manageDoorsWithService.args = {};
manageDoorsWithService.parameters = {
    flags: {
        manage_car_doors: true,
        show_car_service: true,
    },
};

export const blockCar = Template.bind({});
blockCar.args = {};
blockCar.parameters = {
    flags: {
        manage_car_doors: false,
        show_car_service: false,
        car_models_for_block: 'audi_q3_quattro',
    },
};

export const shortLine = Template.bind({});
shortLine.args = {};
shortLine.parameters = {
    flags: {
        manage_car_doors: true,
        flag_car_panic_buttons: true,
    },
};

export const longLine = Template.bind({});
longLine.args = {};
longLine.parameters = {
    flags: {
        manage_car_doors: true,
        flag_car_panic_buttons: true,
        show_car_service: true,
        car_models_for_block: 'audi_q3_quattro',
    },
};
longLine.hermioneFn = async (browser, selector) => {
    const menuEl = '[role="menu"]';
    const dropdown = '[data-testid="dropdown"]';

    await browser.$(dropdown).click();
    await browser.$(menuEl).waitForDisplayed();

    await browser.assertView('opened', [selector, menuEl]);
};
