import * as React from 'react';

import { UseCarBeaconRes } from 'entities/Car/api/useCarBeacon/useCarBeacon';
import { CarSchema } from 'entities/Car/types/CarSchema';

import { SingleCarMap } from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/SingleCarMap';

import styles from 'features/CarLocation/ui/CarLocationMap/CarLocationMap.css';

export interface CarLocationMapProps {
    car: CarSchema;
    beaconInfo?: UseCarBeaconRes;
}

export const CarLocationMap: React.FC<CarLocationMapProps> = function CarLocationMap({ car, beaconInfo }) {
    const { location } = car;
    let { lon = null, lat = null } = location ?? {};

    if (!lon && !lat && beaconInfo) {
        lon = beaconInfo.location.longitude;
        lat = beaconInfo.location.latitude;
    }

    return (
        <SingleCarMap
            className={styles.map}
            buttonsClassName={styles.map_button_container}
            beacon={beaconInfo}
            lon={lon}
            lat={lat}
            carInfo={car}
            isLoading={false}
        />
    );
};
