import { ONE_SECOND } from 'constants/constants';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostCarMaintenanceInfoData {
    vin: string;
    mileage: number;
    date: Date;
}

interface PostCarMaintenanceInfoPayload {
    vin: string;
    mileage: number;
    start_date: number;
    ready_date: number;
}

export function postCarMaintenanceInfo({ vin, mileage, date }: PostCarMaintenanceInfoData) {
    const timestamp = date.getTime() / ONE_SECOND;

    const payload: PostCarMaintenanceInfoPayload = {
        vin,
        mileage,
        start_date: timestamp,
        ready_date: timestamp,
    };

    return fetchRequest<PostCarMaintenanceInfoPayload, unknown>('/api/leasing/maintenance/upsert', payload, {
        method: 'POST',
    });
}
