import { ONE_SECOND } from 'constants/constants';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarMaintenanceInfoReq {
    vin: string;
}

export interface UseCarMaintenanceInfoServerRes {
    maintenance: Array<{
        vin: string;
        start_date: number;
        ready_date: number;
        mileage: number;
        source: string;
        is_intermediate: boolean;
    }>;
}

export type UseCarMaintenanceInfoRes = Array<{
    vin: string;
    start_date: Date;
    ready_date: Date;
    mileage: number;
}>;

export type UseCarMaintenanceInfoResource = UseFetchResource<UseCarMaintenanceInfoRes>;

function carMaintenanceInfoParser(res: UseCarMaintenanceInfoServerRes): UseCarMaintenanceInfoRes {
    return res.maintenance.map((item) => {
        return {
            start_date: new Date(item.start_date * ONE_SECOND),
            ready_date: new Date(item.ready_date * ONE_SECOND),
            mileage: item.mileage,
            vin: item.vin,
        };
    });
}

export function useCarMaintenanceInfo(vin: string) {
    return useFetch<UseCarMaintenanceInfoReq, UseCarMaintenanceInfoRes, UseCarMaintenanceInfoServerRes>(
        '/api/leasing/maintenance/info',
        {
            vin,
        },
        {
            parser: carMaintenanceInfoParser,
        },
    );
}
