import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add maintenance': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add maintenance',
        ru: 'Добавить техническое обслуживание',
        cs: 'Přidat údržbu',
    },
    'Latest maintenance': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Latest maintenance',
        ru: 'Последнее техническое обслуживание',
        cs: 'Poslední údržba',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
