import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add maintenance': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add maintenance',
        ru: 'Добавить техническое обслуживание',
        cs: 'Přidat údržbu',
    },
    'Add maintenance details': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add maintenance details',
        ru: 'Добавить сведения о техническом обслуживании',
        cs: 'Přidat podrobnosti o údržbě',
    },
    Date: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date',
        ru: 'Дата',
        cs: 'Datum',
    },
    'Mileage, km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage, km',
        ru: 'Пробег, км',
        cs: 'Počet ujetých kilometrů, km',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
