import * as React from 'react';
import { useCallback, useState } from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { InputSize } from 'shared/consts/InputSize';
import { Button } from 'shared/ui/Button/Button';
import { FormContainer } from 'shared/ui/FormContainer/FormContainer';
import { FormLabel } from 'shared/ui/FormLabel/FormLabel';
import { Input } from 'shared/ui/Input/Input';
import { InputDateSingle } from 'shared/ui/InputDateSingle/InputDateSingle';
import { ModalContainer, ModalContainerProps } from 'shared/ui/ModalContainer/ModalContainer';

import { i18n } from 'features/CarMaintenance/ui/CarMaintenanceAddModal/CarMaintenanceAddModal.i18n';

export interface CarMaintenanceAddModalForm {
    date: Date;
    mileage: number;
}

export interface CarMaintenanceAddModalProps extends ModalContainerProps {
    onFormSubmit(data: CarMaintenanceAddModalForm): void;
}

export const CarMaintenanceAddModal: React.FC<CarMaintenanceAddModalProps> = function CarMaintenanceAddModal({
    onClose,
    onFormSubmit,
}) {
    // @todo: add useForm, useFormController
    const [date, setDate] = useState<Nullable<Date>>();
    const [mileage, setMileage] = useState<string>();

    const onSubmitClick = useCallback(() => {
        if (date && Number(mileage)) {
            onFormSubmit({ date, mileage: Number(mileage) });

            // @todo: add notification
        } else {
            // todo validation
        }
    }, [onFormSubmit, date, mileage]);

    return (
        <ModalContainer
            title={i18n('Add maintenance details')}
            hasClose
            controls={
                <Button
                    size={ButtonSize.M}
                    color={ButtonColor.PRIMARY}
                    label={i18n('Add maintenance')}
                    onClick={onSubmitClick}
                    disabled={!date || !Number(mileage)}
                />
            }
            onClose={onClose}
        >
            <FormContainer>
                <FormLabel title={i18n('Date')}>
                    <InputDateSingle
                        inputSize={InputSize.M}
                        onDateChange={setDate}
                    />
                </FormLabel>

                <FormLabel title={i18n('Mileage, km')}>
                    <Input
                        type="number"
                        inputMode="numeric"
                        inputSize={InputSize.M}
                        onInputChange={setMileage}
                    />
                </FormLabel>
            </FormContainer>
        </ModalContainer>
    );
};
