import * as React from 'react';
import { useMemo } from 'react';

import { getI18nLocale } from 'utils/language/getI18nLocale';

import { UseCarMaintenanceInfoResource } from 'features/CarMaintenance/api/useCarMaintenanceInfo/useCarMaintenanceInfo';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';
import { getDateString } from 'shared/helpers/getDateString/getDateString';

import Table from 'components/ui/Table';
import { IHeaderInfo, ITableRowData } from 'components/ui/Table/types';

import { i18n } from 'features/CarMaintenance/ui/CarMaintenanceList/CarMaintenanceList.i18n';

export interface CarMaintenanceListProps {
    resource: UseCarMaintenanceInfoResource;
}

export const CarMaintenanceList: React.FC<CarMaintenanceListProps> = function CarMaintenance({
    resource,
}: CarMaintenanceListProps) {
    const maintenanceInfo = resource.read();

    const headers = useMemo<IHeaderInfo[]>(() => {
        return [
            { key: 'date', displayName: i18n('Date') },
            { key: 'mileage', displayName: i18n('Mileage, km') },
        ];
    }, []);

    const locale = getI18nLocale();

    const data = useMemo<ITableRowData[]>(() => {
        return maintenanceInfo.map((item, ind) => {
            return {
                data: {
                    date: getDateString(item.start_date, locale, {
                        year: 'numeric',
                        month: 'short',
                        day: 'numeric',
                    }),

                    mileage: formatNumber(item.mileage),
                },

                meta: {
                    key: String(ind),
                },
            };
        });
    }, [maintenanceInfo]);

    if (!maintenanceInfo.length) {
        return null;
    }

    return (
        <Table
            header={headers}
            tableData={data}
        />
    );
};
