import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Avg. scoring': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Avg. scoring',
        ru: 'Средний скоринг',
        cs: 'Průměrné skóre',
    },
    'Current car scoring': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current car scoring',
        ru: 'Текущий скоринг',
        cs: 'Aktuální skóre vozu',
    },
    Scoring: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Scoring',
        ru: 'Скоринг',
        cs: 'Skóre',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
