import * as React from 'react';

import { UseCarResource } from 'entities/Car/api/useCar/useCar';

import { IslandTheme } from 'shared/consts/IslandTheme';
import { ScoringSize } from 'shared/consts/ScoringSize';
import { useResourceReader } from 'shared/hooks/useResourceReader/useResourceReader';
import { Island } from 'shared/ui/Island/Island';
import { Scoring } from 'shared/ui/Scoring/Scoring';

import CarScoringInformer from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Scoring/CarScoringInformer';
import { CharType } from 'components/Informer';

import { i18n } from 'features/CarScoring/ui/CarScoring/CarScoring.i18n';

import styles from 'features/CarScoring/ui/CarScoring/CarScoring.css';

export interface CarScoringProps {
    resource: UseCarResource;
}

export const CarScoring: React.FC<CarScoringProps> = function CarScoring({ resource }) {
    const car = useResourceReader(resource);

    if (!car || car.signalq) {
        return null;
    }

    return (
        <Island
            title={
                <div className={styles.titleContainer}>
                    <h3 className={styles.title}>{i18n('Scoring')}</h3>

                    <div className={styles.avg}>{i18n('Avg. scoring')}</div>
                </div>
            }
        >
            <Island
                className={styles.scoring}
                title={i18n('Current car scoring')}
                theme={IslandTheme.GRAY}
            >
                <Scoring
                    className={styles.scoringNumber}
                    value={car.aggressive_rank}
                    size={ScoringSize.L}
                />
            </Island>

            <CarScoringInformer
                className={styles.informer}
                car_id={car.id}
                tag_id={car.aggressive_score_tag_id}
                type={CharType.line}
                hideHeader
            />
        </Island>
    );
};
