import { ONE_MILLISECOND } from 'constants/constants';

import { CarServiceFormSchema } from 'entities/Car/types/CarServiceFormSchema';
import { CarServiceSchema } from 'entities/Car/types/CarServiceSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { getTimestampFromDateTime } from 'shared/helpers/getTimestampFromDateTime/getTimestampFromDateTime';

export interface PostCarServiceReq extends Omit<CarServiceSchema, 'until'> {
    until?: number;
}

export function postCarService(data: CarServiceFormSchema) {
    const payload: PostCarServiceReq = {
        car_id: data.car.id,

        since: getTimestampFromDateTime(data.since, data.since_time) * ONE_MILLISECOND,
        until:
            data.until && data.until_time
                ? getTimestampFromDateTime(data.until, data.until_time) * ONE_MILLISECOND
                : undefined,

        job_type: data.job_type?.toString() || '',
        mileage: data.mileage ? Number(data.mileage) : 0,
        job_comment: data.job_comment || '',
    };

    return fetchRequest<PostCarServiceReq, unknown>('/api/leasing/car/tag/add', payload, {
        method: 'POST',
        query: {
            tag_name: 'rental_service_mode_tag',
        },
    });
}
