import { ONE_MILLISECOND, ONE_MINUTE } from 'constants/constants';

import { CarServiceFormSchema } from 'entities/Car/types/CarServiceFormSchema';
import { CarServiceSchema } from 'entities/Car/types/CarServiceSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { getTimestampFromDateTime } from 'shared/helpers/getTimestampFromDateTime/getTimestampFromDateTime';

export interface PostEditCarServiceOptions {
    tagId: string;
}

export interface PostEditCarServiceReq extends Omit<CarServiceSchema, 'car_id' | 'until'> {
    tag: string;
    until?: number;
}

export function postEditCarService(data: CarServiceFormSchema, options: PostEditCarServiceOptions) {
    const payload: PostEditCarServiceReq = {
        tag: 'rental_service_mode_tag',

        since: getTimestampFromDateTime(data.since, data.since_time) * ONE_MILLISECOND,
        until:
            data.until && data.until_time
                ? getTimestampFromDateTime(data.until, data.until_time) * ONE_MILLISECOND
                : undefined,

        job_type: data.job_type?.toString() || '',
        mileage: data.mileage ? Number(data.mileage) : 0,
        job_comment: data.job_comment || '',
    };

    return fetchRequest<PostEditCarServiceReq, unknown>('/api/yandex/tag/evolve', payload, {
        method: 'POST',
        query: {
            tag_id: options.tagId,
        },
        timeout: ONE_MINUTE,
    });
}
