import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add maintenance': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add maintenance',
        ru: 'Добавить техническое обслуживание',
        cs: 'Přidat údržbu',
    },
    Create: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create',
        ru: 'Создать',
        cs: 'Vytvořit',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
