import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { modalScrollState } from 'tests/storybook/helpers/modalScrollState';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarAddServiceModal,
    CarAddServiceModalProps,
} from 'features/CarService/ui/CarAddServiceModal/CarAddServiceModal';

const storybookMeta = createStorybookMeta<CarAddServiceModalProps>({
    title: 'features/CarService/CarAddServiceModal',
    component: CarAddServiceModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarAddServiceModalProps>(CarAddServiceModal);

export const normal = Template.bind({});
normal.hermionePlainFn = async function (browser, selector) {
    await modalScrollState(browser, selector);

    await browser.$('[title="Create"]').click();

    return browser.assertView('withError', selector);
};
