import * as React from 'react';

import { postCarService } from 'features/CarService/api/postCarService/postCarService';
import { CarServiceForm } from 'features/CarService/ui/CarServiceForm/CarServiceForm';

import { CarServiceFormSchema } from 'entities/Car/types/CarServiceFormSchema';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { useFormController } from 'shared/hooks/useFormController/useFormController';
import { Button } from 'shared/ui/Button/Button';
import { ModalContainer, ModalContainerProps } from 'shared/ui/ModalContainer/ModalContainer';

import { i18n } from 'features/CarService/ui/CarAddServiceModal/CarAddServiceModal.i18n';

export interface CarAddServiceModalProps extends Pick<ModalContainerProps, 'onClose'> {
    initial?: Partial<CarServiceFormSchema>;

    onChange?(): void;

    onClose?(): void;
}

export const CarAddServiceModal: React.FC<CarAddServiceModalProps> = function CarAddServiceModal({
    initial,
    onChange,
    onClose,
}) {
    const { getValues, validate, setError, controller } = useFormController<OptionalRecord<CarServiceFormSchema>>();

    const onSubmitHandler = React.useCallback(async () => {
        if (validate()) {
            const data = getValues();

            try {
                await postCarService(data as CarServiceFormSchema);
            } catch (error) {
                return setError('_serverError', getFetchErrorMessage(error));
            }

            // @todo: add notification

            if (onChange) {
                onChange();
            }

            if (onClose) {
                onClose();
            }
        }
    }, [onChange, onClose, getValues, validate]);

    return (
        <ModalContainer
            title={i18n('Add maintenance')}
            hasClose
            controls={
                <Button
                    color={ButtonColor.PRIMARY}
                    size={ButtonSize.M}
                    label={i18n('Create')}
                    onClick={onSubmitHandler}
                />
            }
            onClose={onClose}
        >
            <CarServiceForm
                initial={initial}
                controller={controller}
            />
        </ModalContainer>
    );
};
