import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Delete: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete',
        ru: 'Удалить',
        cs: 'Odstranit',
    },
    'Edit service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit service',
        ru: 'Редактировать техническое обслуживание',
        cs: 'Upravit servis',
    },
    Save: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Save',
        ru: 'Сохранить',
        cs: 'Uložit',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
