import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { modalScrollState } from 'tests/storybook/helpers/modalScrollState';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarEditServiceModal,
    CarEditServiceModalProps,
} from 'features/CarService/ui/CarEditServiceModal/CarEditServiceModal';

const storybookMeta = createStorybookMeta<CarEditServiceModalProps>({
    title: 'features/CarService/CarEditServiceModal',
    component: CarEditServiceModal,

    parameters: {
        date: new Date('2022-04-30T01:22:19'),
    },

    hermioneSelector: '[role="dialog"]',

    args: {
        car: {
            id: '1059ea00-7d98-75b9-d3a9-d4ea4b15828f',
            model_id: 'kia_rio_xline',
            model_name: 'KIA Rio X-Line',
            number: 'к672ев799',
            vin: 'Z94C251ABJR001469',
        },
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarEditServiceModalProps>(CarEditServiceModal);

export const normal = Template.bind({});
normal.args = {
    tagId: '418c4f41-f188-4ea1-b77a-bbe3ac00dbe7',
};
normal.hermionePlainFn = modalScrollState;

export const withoutUntil = Template.bind({});
withoutUntil.args = {
    tagId: '418c4f41-f188-4ea1-b77a-bbe3ac00dbe6',
};
withoutUntil.hermionePlainFn = async function (browser, selector) {
    await modalScrollState(browser, selector);

    await browser.$('[class*="__tooltipLink__"]').click();

    return browser.assertView('updatedDate', selector);
};
