import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Car model or licence plate number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car model or licence plate number',
        ru: 'Модель автомобиля или регистрационный номер',
        cs: 'Model vozu nebo číslo registrační značky',
    },
    Comment: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Comment',
        ru: 'Комментарий',
        cs: 'Komentář',
    },
    Dates: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dates',
        ru: 'Даты',
        cs: 'Data',
    },
    'Enter date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter date and time',
        ru: 'Введите дату и время',
        cs: 'Zadejte datum a čas',
    },
    'Mileage, km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage, km',
        ru: 'Пробег, км',
        cs: 'Počet ujetých kilometrů, km',
    },
    'Move from service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Move from service',
        ru: 'Вернуть',
        cs: 'Přesunout ze servisu',
    },
    Select: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Select',
        ru: 'Выбрать',
        cs: 'Vybrat',
    },
    'Select car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Select car',
        ru: 'Выберите автомобиль',
        cs: 'Vyberte vůz',
    },
    'The car is still in service now.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The car is still in service now.',
        ru: 'Машина все ещё находится на техническом обслуживании.',
        cs: 'Vůz je zatím stále v servisu.',
    },
    'Type of service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Type of service',
        ru: 'Вид технического обслуживания',
        cs: 'Typ servisu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
