import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarServiceForm, CarServiceFormProps } from 'features/CarService/ui/CarServiceForm/CarServiceForm';

import { CarServiceJobType } from 'entities/Car/consts/CarServiceJobType';

const storybookMeta = createStorybookMeta<CarServiceFormProps>({
    title: 'features/CarService/CarServiceForm',
    component: CarServiceForm,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '560px',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarServiceFormProps>(CarServiceForm);

export const normal = Template.bind({});

export const custom = Template.bind({});
custom.args = {
    initial: {
        since: new Date('2022-01-01'),
        car: {
            number: 'кв84666',
            model_id: 'skoda_octavia',
            id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
            status: 'ok',
            location: {
                lat: 55.8208313,
                lon: 37.36984634,
                course: 153,
            },
            telematics: {
                fuel_level: 80,
                fuel_distance: 440,
            },
            view: 0,
            leasing_stats: {},
            taxi_company: {
                name: 'Тестовый таксопарк Берёзка',
                id: 'taxi_company_tag_6658508370',
            },
            model_name: 'Škoda Octavia',
        },
        job_type: CarServiceJobType.SCHEDULED_MAINTENANCE,
        mileage: '200',
        job_comment: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
    },
};

export const withoutCarSwitch = Template.bind({});
withoutCarSwitch.args = { disableCarSwitch: true };
