import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Groups: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Groups',
        ru: 'Группы',
        cs: 'Skupiny',
    },
    Map: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Map',
        ru: 'Карта',
        cs: 'Mapa',
    },
    Schedule: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Schedule',
        ru: 'Расписание',
        cs: 'Rozvrh',
    },
    Table: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Table',
        ru: 'Таблица',
        cs: 'Tabulka',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
