import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { CarsHeaderTabs, CarsHeaderTabsProps } from 'features/CarsHeaderTabs/ui/CarsHeaderTabs/CarsHeaderTabs';

const storybookMeta = createStorybookMeta<CarsHeaderTabsProps>({
    title: 'features/CarsHeaderTabs',
    component: CarsHeaderTabs,

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsHeaderTabsProps>(CarsHeaderTabs);

export const normal = Template.bind({});

export const withGroup = Template.bind({});
withGroup.parameters = { flags: { showCarsGroups: true } };

export const withSchedule = Template.bind({});
withSchedule.parameters = { flags: { cars_schedule: true } };

export const full = Template.bind({});
full.parameters = { flags: { showCarsGroups: true, cars_schedule: true } };
