import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsScheduleGrid,
    CarsScheduleGridProps,
} from 'features/CarsScheduleGrid/ui/CarsScheduleGrid/CarsScheduleGrid';

import { CarsScheduleListItems } from 'entities/Car/ui/CarsScheduleList/CarsScheduleList';

import styles from 'features/CarsScheduleGrid/ui/CarsScheduleGrid/CarsScheduleGrid.story.css';

const ITEMS: CarsScheduleListItems = {
    cars: [
        {
            id: '0',
            car_details: {
                model_name: 'KIA Rio',
                model_id: 'kia_rio',
                number: 'о803вс159',
                vin: 'Z94C241ABMR210676',
                id: '0',
            },
        },
        {
            id: '1',
            car_details: {
                model_name: 'Lada Vesta Sedan Cross XL',
                model_id: 'lada_vesta',
                number: 'е942ка797',
                vin: 'XTAGFL440NY612474',
                id: '1',
            },
        },
        {
            id: '2',
            car_details: {
                model_name: 'KIA Rio',
                model_id: 'kia_rio',
                number: 'о794ен797',
                vin: 'Z94C241ABMR229352',
                id: '2',
            },
        },
        {
            id: '3',
            car_details: {
                model_name: 'Lada Granta',
                model_id: 'lada_granta',
                number: 'к358ха21',
                vin: 'XTA219040N0804468',
                id: '3',
            },
        },
        {
            id: '4',
            car_details: {
                model_name: 'Volkswagen Polo',
                model_id: 'vw_polo',
                number: 'х468ак774',
                vin: 'XW8ZZZ61ZLG031229',
                id: '4',
            },
        },
        {
            id: '5',
            car_details: {
                model_name: 'Hyundai Solaris',
                model_id: 'hyundai_solaris',
                number: '',
                vin: 'Z94K241BBMR224575',
                id: '5',
            },
        },
        {
            id: '6',
            car_details: {
                model_name: 'Renault Logan',
                model_id: 'renault_logan',
                number: 'в486ао774',
                vin: 'X7L4SRLV466809201',
                id: '6',
            },
        },
        {
            id: '7',
            car_details: {
                model_name: 'Škoda Rapid',
                model_id: 'skoda_rapid',
                number: 'у420ео797',
                vin: 'XW8AC2NHXMK133546',
                id: '7',
            },
        },
        {
            id: '8',
            car_details: {
                model_name: 'KIA Rio',
                model_id: 'kia_rio',
                number: 'о962вв716',
                vin: 'Z94C241BBNR250223',
                id: '8',
            },
        },
        {
            id: '9',
            car_details: {
                model_name: 'Škoda Rapid',
                model_id: 'skoda_rapid',
                number: 'у157ав774',
                vin: 'XW8AG2NHXMK111678',
                id: '9',
            },
        },
        {
            id: '10',
            car_details: {
                model_name: 'Škoda Rapid',
                model_id: 'skoda_rapid',
                number: 'у385ах44',
                vin: 'XW8AG2NH2MK117734',
                id: '10',
            },
        },
        {
            id: '11',
            car_details: {
                model_name: 'Kia Cerato',
                model_id: 'kia_cerato',
                number: 'с250но193',
                vin: 'XWEFB416BNC000065',
                id: '11',
            },
        },
    ],
    isFullyLoaded: true,
};

/*eslint-disable @typescript-eslint/no-magic-numbers*/
const storybookMeta = createStorybookMeta<CarsScheduleGridProps>({
    title: 'features/CarsScheduleGrid/CarsScheduleGrid',
    component: CarsScheduleGrid,

    parameters: {
        date: new Date('2022-02-19T21:44:30'),
    },

    args: {
        storybookClassName: 'sb-grid-wrap',
        storybookWidth: '968px',

        className: styles.storyGrid,
        items: ITEMS,
        since: new Date('2022-01-01'),
        until: new Date('2023-01-01'),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleGridProps>(CarsScheduleGrid);

export const normal = Template.bind({});
normal.hermioneFn = async (browser, selector) => {
    await browser.execute(function () {
        const element = document.querySelector('.sb-grid-wrap');

        if (element) {
            element.firstElementChild?.lastElementChild?.scrollTo(1000, 0);
        }
    });

    return browser.assertView('withScroll', selector);
};
