import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsScheduleGridBody,
    CarsScheduleGridBodyProps,
} from 'features/CarsScheduleGrid/ui/CarsScheduleGridBody/CarsScheduleGridBody';

import { CarsScheduleListItems } from 'entities/Car/ui/CarsScheduleList/CarsScheduleList';

import { getDatesInYear } from 'shared/helpers/getDatesInYear/getDatesInYear';

const storybookMeta = createStorybookMeta<CarsScheduleGridBodyProps>({
    title: 'features/CarsScheduleGrid/CarsScheduleGridBody',
    component: CarsScheduleGridBody,

    parameters: { date: new Date('2022-03-31') },

    args: {
        storybookClassName: 'sb-body-wrap',
        storybookWidth: '968px',

        items: {
            cars: [
                { id: '0', car_details: { vin: 'Z94C241ABMR210676' } },
                { id: '1', car_details: { vin: 'XTAGFL440NY612474' } },
                { id: '2', car_details: { vin: 'Z94C241ABMR229352' } },
                { id: '3', car_details: { vin: 'XTA219040N0804468' } },
                { id: '4', car_details: { vin: 'XW8ZZZ61ZLG031229' } },
                { id: '5', car_details: { vin: 'Z94K241BBMR224575' } },
            ],
        } as CarsScheduleListItems,

        since: new Date('2022-01-01'),
        until: new Date('2022-04-01'),
        months: getDatesInYear(new Date('2022-01-01'), new Date('2022-04-01')),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleGridBodyProps>(CarsScheduleGridBody);

export const normal = Template.bind({});
normal.hermioneFn = async (browser, selector) => {
    await browser.execute(function () {
        const element = document.querySelector('.sb-body-wrap');

        if (element) {
            // eslint-disable-next-line @typescript-eslint/no-magic-numbers
            element.firstElementChild?.scrollTo(1000, 0);
        }
    });

    return browser.assertView('withScroll', selector);
};

export const hovered = Template.bind({});
hovered.args = { hoveredItem: '2' };
