import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsScheduleGridCalendar,
    CarsScheduleGridCalendarProps,
} from 'features/CarsScheduleGrid/ui/CarsScheduleGridCalendar/CarsScheduleGridCalendar';

import { getDatesInYear } from 'shared/helpers/getDatesInYear/getDatesInYear';

/*eslint-disable @typescript-eslint/no-magic-numbers*/
const storybookMeta = createStorybookMeta<CarsScheduleGridCalendarProps>({
    title: 'features/CarsScheduleGrid/CarsScheduleGridCalendar',
    component: CarsScheduleGridCalendar,

    args: {
        storybookClassName: 'sb-calendar-wrap',
        storybookWidth: '968px',
        storybookStyles: { overflowX: 'auto' },

        months: getDatesInYear(new Date('2022-01-01'), new Date('2022-04-01')),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleGridCalendarProps>(CarsScheduleGridCalendar);

export const normal = Template.bind({});
normal.hermioneFn = async (browser, selector) => {
    await browser.execute(function () {
        const element = document.querySelector('.sb-calendar-wrap');

        if (element) {
            element.scrollTo(1000, 0);
        }
    });

    return browser.assertView('withScroll', selector);
};
