import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsScheduleGridHeader,
    CarsScheduleGridHeaderProps,
} from 'features/CarsScheduleGrid/ui/CarsScheduleGridHeader/CarsScheduleGridHeader';

import { getDatesInYear } from 'shared/helpers/getDatesInYear/getDatesInYear';

/*eslint-disable @typescript-eslint/no-magic-numbers*/
const storybookMeta = createStorybookMeta<CarsScheduleGridHeaderProps>({
    title: 'features/CarsScheduleGrid/CarsScheduleGridHeader',
    component: CarsScheduleGridHeader,

    args: {
        storybookWidth: '968px',

        months: getDatesInYear(new Date('2022-01-01'), new Date('2022-04-01')),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleGridHeaderProps>(CarsScheduleGridHeader);

export const normal = Template.bind({});

export const withControls = Template.bind({});
withControls.args = {
    controls: (
        <>
            <span style={{ width: '100px', height: '40px', backgroundColor: 'pink', display: 'block' }} />
            <span style={{ width: '40px', height: '40px', backgroundColor: 'pink', display: 'block' }} />
        </>
    ),
};
