import * as React from 'react';
import cn from 'classnames';

import {
    CarsScheduleGridCalendar,
    CarsScheduleGridCalendarProps,
} from 'features/CarsScheduleGrid/ui/CarsScheduleGridCalendar/CarsScheduleGridCalendar';

import styles from 'features/CarsScheduleGrid/ui/CarsScheduleGridHeader/CarsScheduleGridHeader.css';

export interface CarsScheduleGridHeaderProps extends Pick<CarsScheduleGridCalendarProps, 'months'> {
    className?: string;
    controls?: React.ReactNode;
    calendarRef?: React.Ref<HTMLDivElement>;
}

export const CarsScheduleGridHeader: React.FC<CarsScheduleGridHeaderProps> = function CarsScheduleGridHeader({
    className,
    controls,
    months,
    calendarRef,
}) {
    return (
        <div className={cn(styles.header, className)}>
            {controls && <div className={styles.controls}>{controls}</div>}

            <CarsScheduleGridCalendar
                className={styles.calendar}
                months={months}
                ref={calendarRef}
            />
        </div>
    );
};
