import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsScheduleGridItem,
    CarsScheduleGridItemProps,
} from 'features/CarsScheduleGrid/ui/CarsScheduleGridItem/CarsScheduleGridItem';

import { CarOfferStatusSchema } from 'entities/Car/types/CarOfferStatusSchema';

const storybookMeta = createStorybookMeta<CarsScheduleGridItemProps<unknown>>({
    title: 'features/CarsScheduleGrid/CarsScheduleGridItem',
    component: CarsScheduleGridItem,

    parameters: {
        date: new Date('2022-01-01'),
    },

    args: {
        storybookStyles: { lineHeight: 0 },

        gridStartDate: new Date('2022-01-01'),
        payload: {},
        status: 'unknown' as CarOfferStatusSchema,
        since: new Date('2022-01-01T09:00:00'),
        until: new Date('2022-01-10T09:00:00'),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleGridItemProps<unknown>>(CarsScheduleGridItem);

export const unknown = Template.bind({});

export const draft = Template.bind({});
draft.args = { status: 'Draft' };

export const confirmed = Template.bind({});
confirmed.args = { status: 'Confirmed' };

export const paid = Template.bind({});
paid.args = { status: 'Paid' };

export const service = Template.bind({});
service.args = { status: 'Service' };

export const tiny = Template.bind({});
tiny.args = { until: new Date('2022-01-01T21:00:00') };

export const small = Template.bind({});
small.args = { until: new Date('2022-01-02T09:00:00') };
