import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Car in service': {
        _meta: {
            context: 'Car schedule modal window short title',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car in service',
        ru: 'В сервисе',
        cs: 'Vůz v servisu',
    },
    'Confirmed and paid booking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Confirmed and paid booking',
        ru: 'Подтвержденное и оплаченное бронирование',
        cs: 'Potvrzená a zaplacená rezervace',
    },
    'Confirmed booking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Confirmed booking',
        ru: 'Подтвержденное бронирование',
        cs: 'Potvrzená rezervace',
    },
    'Draft booking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Draft booking',
        ru: 'Неподтвержденное бронирование',
        cs: 'Předběžná rezervace',
    },
    'Ride finished': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Ride finished',
        ru: 'Аренда завершена',
        cs: 'Jízda dokončena',
    },
    'Ride in progress': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Ride in progress',
        ru: 'Аренда в процессе',
        cs: 'Probíhá jízda',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
