import { CarOfferSessionStatus } from 'entities/Car/consts/CarOfferSessionStatus';
import { getCarOfferSessionStatus } from 'entities/Car/helpers/getCarOfferSessionStatus/getCarOfferSessionStatus';
import { CarOfferStatusSchema } from 'entities/Car/types/CarOfferStatusSchema';

import { i18n } from 'features/CarsSchedulePopup/helpers/getCarsSchedulePopupTitle/getCarsSchedulePopupTitle.i18n';

const STATUSES: Record<
    CarOfferSessionStatus.IN_PROGRESS | CarOfferSessionStatus.COMPLETED | CarOfferStatusSchema,
    string
> = {
    draft: i18n('Draft booking'),
    confirmed: i18n('Confirmed booking'),
    paid: i18n('Confirmed and paid booking'),
    service: i18n('Car in service'),
    [CarOfferSessionStatus.IN_PROGRESS]: i18n('Ride in progress'),
    [CarOfferSessionStatus.COMPLETED]: i18n('Ride finished'),
};

export function getCarsSchedulePopupTitle(status: CarOfferStatusSchema, since?: Date, until?: Date): string {
    const actionStatus = getCarOfferSessionStatus({ actual_since: since, actual_until: until });

    if (status !== 'service' && actionStatus) {
        return STATUSES[actionStatus];
    }

    if (STATUSES[status]) {
        return STATUSES[status];
    }

    // return draft if unknown status
    return STATUSES.draft;
}
