import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsScheduleBasePopup,
    CarsScheduleBasePopupProps,
} from 'features/CarsSchedulePopup/ui/CarsScheduleBasePopup/CarsScheduleBasePopup';

const storybookMeta = createStorybookMeta<CarsScheduleBasePopupProps>({
    title: 'features/CarsSchedulePopup/CarsScheduleBasePopup',
    component: CarsScheduleBasePopup,

    hermioneSelector: '[role="dialog"]',

    args: {
        isTailHidden: true,
        title: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
        controls: (
            <>
                <div style={{ height: '40px', width: '100%', backgroundColor: 'pink' }} />
                <div style={{ height: '40px', width: '100%', backgroundColor: 'pink' }} />
            </>
        ),
        children: <div style={{ height: '240px', backgroundColor: 'pink' }} />,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsScheduleBasePopupProps>(CarsScheduleBasePopup);

export const normal = Template.bind({});
